/*global define */
/*jslint white: true */

/*
	treeAmount:

	This object provides a mixin for each tree attenuated amount (like alpha or volume).
*/

define  ([  "src/utils"],
function(   utils) {
	'use strict';

	function identity (obj) {
		return obj;
	}

	function mixin (options0) {
		var options = options0 || {},
			enabledL = options.enabledLabel || "enabled",
			amountL = options.amountLabel || "amount",
			disabledAmountL = options.disabledAmountLabel || "disabledAmount",
			changeNotifierType = options.changeNotifierType || "amountChanged",
			treeInfo = options.getTreeInfo || identity,
			p;

		function getRenameMethodName(inName) {
			if (options.rename && options.rename[inName]) {
				inName = options.rename[inName] || inName;
			}
			return inName;
		}
		
		function getRenameMethod(inObj, inName) {
			return inObj[getRenameMethodName(inName)];
		}
		
		p = {};
		
		p[getRenameMethodName("setAmount")] = 
			function (amount) {
				var info = treeInfo(this);
				if (info[enabledL]) {
					if (info[amountL] !== amount) {
						info[amountL] = amount;
						if (this.callChangeNotifiers) {
							this.callChangeNotifiers(changeNotifierType);
						}
					}
				} else {
					info[disabledAmountL] = amount;
				}
			};

		p[getRenameMethodName("getAmount")] = 
			function () {
				var info = treeInfo(this), v;
				if (info[enabledL]) {
					v = info[amountL];
				} else {
					v = info[disabledAmountL];
				}
				return v;
			};

		p[getRenameMethodName("getEffectiveAmount")] = 
			 function () {
				var info = treeInfo(this), v;
				return info[amountL];
			};

		p[getRenameMethodName("getAmountToRoot")] = 
			function () {
				var amount = 1, that = this;

				while (that !== undefined) {
					amount *= getRenameMethod(that, "getEffectiveAmount").call(that);
					if (amount <= 0) {
						return 0;
					}
					that = that.getParent !== undefined ? that.getParent() : undefined;
				}
				return amount;
			};

		p[getRenameMethodName("isRelevant")] = 
			function () {
				var amount = getRenameMethod(this, "getAmountToRoot").call(this);

				return amount > 0;
			};

		p[getRenameMethodName("setEnabled")] =
			function (enabled) {
				var info = treeInfo(this), newAmount;

				enabled = (enabled === undefined) ? true : !!enabled; // Converts int to boolean.
				if (info[enabledL] !== enabled) {
					info[enabledL] = enabled;
					if (enabled) {
						newAmount = info[disabledAmountL] || info[amountL];
						info[disabledAmountL] = undefined;
					} else {
						newAmount = 0;
						info[disabledAmountL] = info[amountL];
					}
					info[amountL] = newAmount;
					if (this.callChangeNotifiers) {
						this.callChangeNotifiers(changeNotifierType);
					}
				}
			};

		p[getRenameMethodName("getEnabled")] =
			function () {
				var info = treeInfo(this), newAmount;
				return info[enabledL];
			};
		
		return p;
	}

	return mixin;
});
